% Series HEV Simulation Initialization
%
% Mike Rothenberger
% 5/31/12

% Constants
R_cell = 0.0522;
cells = 6000;
FDR = 6.0;
Q_batt = 1.1; 

% 2D Lookup table values for the engine torque
engine_RPM=[0 700. 800. 1000. 1500. 2000. 2500. 3000. 3300. 3800. 4300.];
engine_rad=[0 73.30 83.78 104.72 157.08 209.44 261.80 314.16 345.58 397.94 450.30];
mdot=[0 0.025  0.05  0.1  0.15  0.2  0.25  0.3  0.35  0.4];
throttle = [-0.4 -0.35 -0.3 -0.25 -0.2 -0.15 -0.1 -0.05 -0.025 0];

% New torque data from paper with torque converter
tau_engine=[
0   0           0        0       0       0       0       0       0       0;
0   9.06    73.99   190.27  283.89  360.91  413.76  445.47  454.53  465.28;
0   -19.63  52.85   181.21  286.91  368.46  427.35  462.08  471.14  483.22;
0   3.02    63.42   178.19  288.42  389.60  483.22  567.79  647.82  717.28;
0   9.06    67.95   182.72  295.97  409.23  520.97  629.70  738.42  847.15;
0   -13.59  49.83   175.17  292.95  407.72  517.95  632.72  750.50  869.80;
0   55.87   87.58   169.13  270.30  380.54  498.32  614.60  726.34  826.00;
0   52.85   80.03   146.48  237.08  339.76  454.53  564.76  673.50  770.13;
0   66.44   80.03   129.87  208.39  311.07  422.82  539.09  653.86  750.50;
0   46.51   56.02   90.91   145.87  217.75  295.97  377.37  457.70  525.35;
0   32.56   39.22   63.63   102.11  152.43  207.18  264.16  320.39  367.74];

% Demanded Power
P_ice_dem = [0.0    0.0     0.0     0.0     0.0     0.0     0.0     0.0     0.0     0.0     0.0     0.0   0.0;
             8.22   0.64    0.0     0.0     0.0     0.0     0.0     0.0     0.0     0.0     0.0     0.0   0.0;
             44.42  3.36    0.0     0.0     0.0     0.0     0.0     0.0     0.0     0.0     0.0     0.0   0.0;
             67.63  8.22    0.22    0.0     0.0     0.0     0.0     0.0     0.0     0.0     0.0     0.0   0.0;
             88.74  24.26   16.26   9.26    0.26    0.0     0.0     0.0     0.0     0.0     0.0     0.0   0.0;
             88.74  44.42   36.42   28.42   20.42   12.42   4.42    0.0     0.0     0.0     0.0     0.0   0.0;
             88.74  56.29   48.29   40.29   32.29   24.29   16.29   8.29    0.29    0.0     0.0     0.0   0.0;
             88.74  67.63   59.63   51.63   43.63   35.63   27.63   19.63   11.63   3.63    0.0     0.0   0.0;
             88.74  78.45   70.45   62.45   54.45   46.45   38.45   30.45   22.45   14.45   6.45    0.0   0.0;
             88.74  88.74   80.74   72.74   64.74   56.74   48.74   40.74   32.74   24.74   16.74   8.74  0.0];
        
MG_dem = [0.0; 640; 3360; 8220; 24260; 44420; 56290; 67630; 78450; 88740];
SOC_ICE = [35 40 45 50 55 60 65 70 75 80 85 90 95];

P_ice = [0 0.64 3.36 8.22 24.26 44.42 56.29 67.63 78.45 88.74];
ES_dem = [0; 83.78; 83.78; 83.78; 157.08; 209.44; 209.44; 209.44; 209.44; 209.44];
T_dem = [0; 7.65; 40.16; 98.13; 154.44; 212.10; 268.78; 322.93; 374.57; 423.70];

% Rows are MG speed values and Columns are Torque values
MGS = [0; 52.36; 104.72; 157.08; 209.44; 261.80; 314.16; 366.52;
    418.88; 471.24; 523.60; 575.96; 628.32; 680.68; 733.04; 785.40];

GT = [-573 -525 -450 -375 -300 -225 -150 -75 0 75 150 225 300 375 450 525 573];
MT = [-765 -700 -600 -500 -400 -300 -200 -100 0 100 200 300 400 500 600 700 765];

% Efficiency values for 180 kW electric motor/generator
Eff = zeros(16,17);
Eff(:,1) = [65; 65; 70; 75; 82; 0; 0; 0; 0; 0; 0; 0; 0; 0; 0; 0];
Eff(:,2) = [65; 65; 70; 75; 82; 86; 0; 0; 0; 0; 0; 0; 0; 0; 0; 0];
Eff(:,3) = [65; 65; 70; 75; 86; 86; 86; 0; 0; 0; 0; 0; 0; 0; 0; 0];
Eff(:,4) = [65; 65; 75; 82; 86; 90; 90; 86; 0; 0; 0; 0; 0; 0; 0; 0];
Eff(:,5) = [70; 70; 78; 82; 90; 92; 92; 92; 86; 86; 0; 0; 0; 0; 0; 0];
Eff(:,6) = [70; 70; 75; 86; 90; 94; 94; 94; 94; 92; 90; 86; 86; 86; 0; 0];
Eff(:,7) = [70; 70; 75; 86; 90; 94; 94; 96; 96; 96; 96; 94; 92; 90; 86; 86];
Eff(:,8) = [70; 70; 70; 75; 75; 75; 75; 75; 75; 75; 75; 75; 75; 75; 75; 78];
Eff(:,9) = [50; 50; 50; 50; 50; 50; 50; 50; 50; 50; 50; 50; 50; 50; 50; 50];
Eff(:,10) = [70; 70; 70; 75; 75; 75; 75; 75; 75; 75; 75; 75; 75; 75; 75; 75];
Eff(:,11) = [70; 70; 75; 86; 90; 94; 94; 96; 96; 96; 96; 94; 92; 90; 86; 86];
Eff(:,12) = [70; 70; 75; 86; 90; 94; 94; 94; 94; 92; 90; 86; 86; 86; 0; 0];
Eff(:,13) = [70; 70; 75; 82; 90; 92; 92; 92; 86; 86; 0; 0; 0; 0; 0; 0];
Eff(:,14) = [65; 65; 75; 82; 86; 90; 90; 86; 0; 0; 0; 0; 0; 0; 0; 0];
Eff(:,15) = [65; 65; 70; 75; 86; 86; 86; 0; 0; 0; 0; 0; 0; 0; 0; 0];
Eff(:,16) = [65; 65; 70; 75; 82; 86; 0; 0; 0; 0; 0; 0; 0; 0; 0; 0];
Eff(:,17) = [65; 65; 70; 75; 82; 0; 0; 0; 0; 0; 0; 0; 0; 0; 0; 0];

% Open Circuit Voltage as a Function of SOC for A123 18650 cell
V = [2.000; 2.760; 2.885; 2.963; 3.020; 3.066; 3.103; 3.136; 3.163; 3.188; 
     3.209; 3.225; 3.233; 3.237; 3.241; 3.245; 3.250; 3.256; 3.262; 3.268; 
     3.273; 3.279; 3.284; 3.288; 3.292; 3.295; 3.299; 3.303; 3.306; 3.310; 
     3.313; 3.315; 3.318; 3.320; 3.321; 3.323; 3.323; 3.324; 3.324; 3.324; 
     3.325; 3.325; 3.325; 3.326; 3.326; 3.327; 3.327; 3.328; 3.329; 3.329; 
     3.330; 3.330; 3.331; 3.332; 3.333; 3.334; 3.335; 3.336; 3.337; 3.338; 
     3.339; 3.340; 3.341; 3.343; 3.344; 3.345; 3.347; 3.348; 3.350; 3.351; 
     3.353; 3.355; 3.356; 3.358; 3.359; 3.361; 3.362; 3.363; 3.364; 3.364; 
     3.365; 3.365; 3.366; 3.366; 3.367; 3.367; 3.368; 3.369; 3.370; 3.371; 
     3.373; 3.375; 3.378; 3.381; 3.386; 3.394; 3.405; 3.423; 3.453; 3.505; 
     3.600];

SOC = 1:1:101;
 
Torq = [0 100 200 500 765 765 765 765 765 765;
        0 20  200 400 765 765 765 765 765 765;
        0 20  100 400 600 765 765 765 765 765;
        0 20  50  200 400 765 765 765 765 765;
        0 20  50  200 300 400 765 765 765 765;
        0 20  50  100 200 300 500 700 700 700;
        0 20  50  100 200 300 400 600 600 600;
        0 20  50  100 200 300 300 500 500 500;
        0 20  50  100 200 200 300 400 400 400;
        0 20  50  100 200 200 300 400 400 400;
        0 20  50  100 100 200 300 300 300 300;
        0 20  50  100 100 200 200 300 300 300;
        0 20  50  100 100 100 200 300 300 300;
        0 20  50  100 100 100 200 200 300 300;
        0 20  50  100 100 100 200 200 200 200;
        0 20  50  100 100 100 200 200 200 200];
    
Regen = [-765 -765 -765 -765 -765 -765 -500 -200 -100 0;
         -765 -765 -765 -765 -765 -765 -400 -200 -20  0;
         -765 -765 -765 -765 -765 -600 -400 -100 -20  0;
         -765 -765 -765 -765 -765 -400 -200 -50  -20  0;
         -765 -765 -765 -765 -400 -300 -200 -50  -20  0;
         -700 -700 -700 -500 -300 -200 -100 -50  -20  0;
         -600 -600 -600 -400 -300 -200 -100 -50  -20  0;
         -500 -500 -500 -300 -300 -200 -100 -50  -20  0;
         -400 -400 -400 -300 -200 -200 -100 -50  -20  0;
         -400 -400 -400 -300 -200 -200 -100 -50  -20  0;
         -300 -300 -300 -300 -200 -100 -100 -50  -20  0;
         -300 -300 -300 -200 -200 -100 -100 -50  -20  0;
         -300 -300 -300 -200 -100 -100 -100 -50  -20  0;
         -300 -300 -200 -200 -100 -100 -100 -50  -20  0;
         -200 -200 -200 -200 -100 -100 -100 -50  -20  0;
         -200 -200 -200 -200 -100 -100 -100 -50  -20  0];
    
% Drive cycle (ftp75)
load('ftp75.mat')

time = ftp75(:,1);
ftp = ftp75(:,2);
    
    
    